/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.dao;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.dto.CmAspUserDto;
import jp.mosp.common.dto.CmUserDto;
import jp.mosp.payroll.base.PayrollConst;
import jp.mosp.payroll.base.PayrollDao;
import jp.mosp.payroll.dto.DetailPdDto;

public class PmDetailPdDao extends PayrollDao {
	
	/**
	 *  e[uB<br>
	 */
	public static final String TABLE = "PM_DETAIL_PD";
	
	/**
	 *  L[1B<br>
	 */
	public static final String KEY_01 = "DETAIL_CODE";
	
	public static final String COL_DETAIL_CODE  = "DETAIL_CODE" ;
	public static final String COL_DETAIL_NAME  = "DETAIL_NAME" ;
	public static final String COL_DETAIL_ABBR  = "DETAIL_ABBR" ;
	
	public static final String COL_LEAVE_TYPE   = "LEAVE_TYPE"  ;
	
	public static final String COL_DISPLAY_TYPE = "DISPLAY_TYPE";
	public static final String COL_EXPRESSION   = "EXPRESSION"  ;
	public static final String COL_INPUT_TYPE   = "INPUT_TYPE"  ;
	public static final String COL_EDIT_FLAG    = "EDIT_FLAG"   ;
	public static final String COL_DELETE_FLAG  = "DELETE_FLAG" ;
	
	/**
	 * {@link PayrollDao#PayrollDao(Properties, String, CmAspUserDto, CmUserDto, Connection)}
	 * sB<br>
	 * @param cfg     ݒt@C
	 * @param cmd     R}h
	 * @param aspUser ASP[U[
	 * @param user    [U[
	 * @param conn    DBRlNV
	 */
	public PmDetailPdDao(
			Properties   cfg,
			String       cmd,
			CmAspUserDto aspUser,
			CmUserDto    user,
			Connection   conn
	) {
		super(cfg, cmd, aspUser, user, conn);
	}
	
	/**
	 * ʂDTOƂĎ擾B<br>
	 * @return R[h(DTO)
	 * @throws SQLException
	 */
	private DetailPdDto mapping() throws SQLException {
		DetailPdDto dto = new DetailPdDto();
		dto.setDetailCode (rs.getString(COL_DETAIL_CODE ));
		dto.setDetailName (rs.getString(COL_DETAIL_NAME ));
		dto.setDetailAbbr (rs.getString(COL_DETAIL_ABBR ));
		dto.setLeaveType  (rs.getByte  (COL_LEAVE_TYPE  ));
		dto.setDisplayType(rs.getByte  (COL_DISPLAY_TYPE));
		dto.setExpression (rs.getString(COL_EXPRESSION  ));
		dto.setInputType  (rs.getByte  (COL_INPUT_TYPE  ));
		dto.setEditFlag   (rs.getByte  (COL_EDIT_FLAG   ));
		dto.setDeleteFlag (rs.getByte  (COL_DELETE_FLAG ));
		mappingCommonInfo(dto);
		return dto;
	}
	
	/**
	 * ʂDTOListƂĎ擾B<br>
	 * @return ʃXg
	 * @throws SQLException
	 */
	private List<DetailPdDto> mappingAll() throws SQLException {
		List<DetailPdDto> all = new ArrayList<DetailPdDto>();
		while (rs.next()) {
			all.add(mapping());
		}
		return all;
	}
	
	/**
	 * Sf[^擾
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<DetailPdDto> findAll() throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			prepareStatement(getSelectQuery(getClass()) + getOrderForKey(getClass()));
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂf[^擾B
	 * @param detailCode ׍ڃR[h(L[)
	 * @return dto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public DetailPdDto findForKey(
			String detailCode
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()));
			setParam(index++, detailCode);
			executeQuery();
			DetailPdDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂf[^yэsbN擾B
	 * @param detailCode ׍ڃR[h(L[)
	 * @return dto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public DetailPdDto findForUpdate(
			String detailCode
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) +
					getConditionForKey(getClass()) + getForUpdate());
			setParam(index++, detailCode);
			executeQuery();
			DetailPdDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾B<br>
	 * @param detailAbbr  ח
	 * @param deleteFlag  폜tO
	 * @param sortKey     \[gL[
	 * @param isAscending tO
	 * @param limit       ~bg
	 * @param offset      ItZbg
	 * @return (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<DetailPdDto> find(
			String  detailAbbr ,
			String  deleteFlag ,
			String  sortKey    ,
			boolean isAscending,
			int     limit      ,
			int     offset
	) throws SQLException, IllegalAccessException {
		try {
			index = 1;
			prepareStatement(getSelectStatement(getClass()) +
					getConditionForDetailList(deleteFlag) + getPageStatement(sortKey, isAscending));
			setParam(index++, "%" + detailAbbr + "%");
			if (deleteFlag != null && !deleteFlag.equals("")) {
				setParam(index++, Byte.parseByte(deleteFlag));
			}
			setParam(index++, limit );
			setParam(index++, offset);
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂ蓾f[^̌擾B<br>
	 * @param detailAbbr ח
	 * @param deleteFlag 폜tO
	 * @return int 
	 * @throws SQLException
	 */
	public int count(String detailAbbr, String deleteFlag) throws SQLException {
		try {
			index = 1;
			prepareStatement(getSelectCountStatement() + getConditionForDetailList(deleteFlag));
			setParam(index++, "%" + detailAbbr + "%");
			if (deleteFlag != null && !deleteFlag.equals("")) {
				setParam(index++, Byte.parseByte(deleteFlag));
			}
			executeQuery();
			int count = 0;
			if (rs.next()) {
				count = rs.getInt(1);
			}
			return count;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * אݒꗗpSQL擾B
	 * @param deleteFlag 폜tO
	 * @return	^vZpSQL 
	 */
	private static String getConditionForDetailList(String deleteFlag) {
		StringBuffer sb = new StringBuffer();
		sb.append("FROM " + TABLE + " ");
		sb.append("WHERE ");
		sb.append(COL_DETAIL_ABBR + " LIKE ? ");
		if (deleteFlag == null || deleteFlag.equals("")) {
			return sb.toString();
		}
		sb.append("AND ");
		sb.append(COL_DELETE_FLAG + " = ? ");
		return sb.toString();
	}
	
	/**
	 * ɂf[^擾B
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<DetailPdDto> findNotDelete(
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("WHERE ");
			sb.append(COL_DELETE_FLAG + " = " + MospConst.DELETE_FLAG_OFF + " ");
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * PS_SLIPɐݒ肳Ă閾׃Xg擾B
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<DetailPdDto> findForSlip(
			String slipCode
	)throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectStatement(getClass(), true) +
					PsSlipDao.getQueryForSlip(getTable(getClass())));
			setParam(index++, slipCode);
			setParam(index++, PayrollConst.DETAIL_TYPE_PD);
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^}B<br>
	 * @param dto     }ΏDTO
	 * @param needLog OvۃtO
	 * @return }()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int insert(
			DetailPdDto dto, boolean needLog
	) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getInsertQuery(getClass()));
			setParams(dto, true);
			executeUpdate(needLog);
			chkInsert(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^XVB<br>
	 * @param dto XVΏDTO
	 * @param needLog OvۃtO
	 * @return XV()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int update(
			DetailPdDto dto, boolean needLog
	) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getUpdateQuery(getClass()));
			setParams(dto, false);
			setParam(index++, dto.getDetailCode());
			executeUpdate(needLog);
			chkUpdate(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * p[^ݒ肷B<br>
	 * @param dto      XVΏDTO
	 * @param isInsert }tO(trueF}AfalseFXV)
	 * @throws SQLException
	 */
	private void setParams(DetailPdDto dto, boolean isInsert) throws SQLException {
		setParam(index++, dto.getDetailCode ());
		setParam(index++, dto.getDetailName ());
		setParam(index++, dto.getDetailAbbr ());
		setParam(index++, dto.getLeaveType  ());
		setParam(index++, dto.getDisplayType());
		setParam(index++, dto.getExpression ());
		setParam(index++, dto.getInputType  ());
		setParam(index++, dto.getEditFlag   ());
		setParam(index++, dto.getDeleteFlag ());
		setCommonParams(isInsert);
	}
	
}
